/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.ftp.LocalFile;
import com.quantumdata.ftpbrowser.FileBrowserPanel;
import com.quantumdata.ftpbrowser.FtpOpenHandler;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.LogViewer;
import com.quantumdata.std.RemoteInstrument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class FtpBrowser
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private RemoteInstrument m_instrument = null;
    private FileBrowserPanel m_remoteBrowser;
    private FileBrowserPanel m_localBrowser;
    private FtpConnect m_con = new FtpConnect();
    private Ftp m_ftpServer = new Ftp();
    private LogViewer m_console;
    private IQDPluginContext m_context;

    public RemoteInstrument getInstrument() {
        return this.m_instrument;
    }

    public Ftp getFtpServer() {
        return this.m_ftpServer;
    }

    public FtpBrowser(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.createComponents();
    }

    protected void createComponents() {
        this.setLayout(new BorderLayout(3, 3));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Log");
        JMenuItem jMenuItem = new JMenuItem("Show Log");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("ViewLog");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.add((Component)jMenuBar, "North");
        this.m_remoteBrowser = new FileBrowserPanel(this, "Instrument Files", true);
        this.m_localBrowser = new FileBrowserPanel(this, "Host Files", false);
        JSplitPane jSplitPane = new JSplitPane(1, this.m_remoteBrowser, this.m_localBrowser);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        this.add((Component)jSplitPane, "Center");
        jSplitPane.setDividerSize(12);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(0.5);
        this.m_console = new LogViewer("FTP Log");
        this.m_ftpServer.getContext().setConsole(this.m_console);
    }

    public void setOpenHandler(FtpOpenHandler ftpOpenHandler) {
        this.m_remoteBrowser.setOpenHandler(ftpOpenHandler);
        this.m_localBrowser.setOpenHandler(ftpOpenHandler);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Connect")) {
            this.Connect();
            return;
        }
        if (actionEvent.getActionCommand().equals("ViewLog")) {
            this.m_console.setVisible(true);
            return;
        }
    }

    public boolean transferFiles(List list, boolean bl) {
        if (bl) {
            return this.m_localBrowser.transferFiles(list);
        }
        return this.m_remoteBrowser.transferFiles(list);
    }

    public void Connect() {
        RemoteInstrument remoteInstrument = this.m_context.getConnectionManager().getDefaultInstrument();
        this.setInstrument(remoteInstrument);
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
        if (this.m_ftpServer.isConnected()) {
            this.m_ftpServer.disconnect();
        }
        try {
            CoFile coFile;
            File[] fileArray;
            if (this.m_instrument != null) {
                fileArray = (File[])this.m_instrument.getConnection();
                this.m_con.setHostName(fileArray.getHostName());
                this.m_con.setPassWord("");
                this.m_con.setUserName("");
                if (!this.m_instrument.isConnected()) {
                    this.m_console.print("*** FTP Connection Failed ***");
                    this.m_console.setVisible(true);
                } else {
                    if (!this.m_ftpServer.connect(this.m_con)) {
                        this.m_console.print("*** FTP Connection Failed ***");
                        this.m_console.setVisible(true);
                        return;
                    }
                    coFile = new FtpFile(this.m_ftpServer.pwd(), this.m_ftpServer);
                    this.m_remoteBrowser.dirSelected(coFile);
                }
            } else {
                this.m_remoteBrowser.dirSelected(null);
            }
            fileArray = File.listRoots();
            String string = "/";
            for (int i = 0; i < fileArray.length; ++i) {
                char c = fileArray[i].toString().toUpperCase().charAt(0);
                if (c == 'A' || c == 'B') continue;
                string = fileArray[i].toString();
                break;
            }
            coFile = new LocalFile(string);
            this.m_localBrowser.dirSelected(coFile);
        }
        catch (IOException iOException) {
            this.m_console.print("\nERROR" + iOException.getMessage());
            this.m_console.setVisible(true);
        }
    }

    public boolean closing() {
        if (this.m_ftpServer.isConnected()) {
            this.m_ftpServer.disconnect();
        }
        return true;
    }

    public void starting() {
        this.Connect();
    }
}

